/*----------------------------------------------------------------------

  SnapClip.c -- defines structure of SnapClip

  ----------------------------------------------------------------------

  Copyright (C). 2003 Smoky Monkey Factory All Rights Reserved
  http://andmore.jp/mobile/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: SnapClip.c,v 1.5 2003/07/20 01:58:38 zxn Exp $

  ----------------------------------------------------------------------*/

#include <PalmOS.h>
#include "SnapCLip.h"
#include "Prefs.h"
#include "Etc.h"

prefsObj g_prefs;

/*----------------------------------------------------------------------
  Get preferences, open (or create) app database 
  ----------------------------------------------------------------------*/
UInt16 StartApplication(void)
{
  g_prefs = prefs_New(); 
  mainForm_Start();

  return 0;
}

/*----------------------------------------------------------------------
  Save preferences, close forms, close app database 
  ----------------------------------------------------------------------*/
void StopApplication(void)
{
  prefs_Save(g_prefs);
  prefs_Delete(g_prefs);

  FrmSaveAllForms();
  FrmCloseAllForms();
}

/*----------------------------------------------------------------------
  handle application event xxx
  ----------------------------------------------------------------------*/
Boolean ApplicationHandleEvent(EventPtr e)
{
  FormPtr frm;
  UInt16 formId;
  Boolean handled = false;

  if (e->eType == frmLoadEvent) 
    {
      formId = e->data.frmLoad.formID;
      frm = FrmInitForm(formId);
      FrmSetActiveForm(frm);

      switch(formId) 
	{
	case MAIN_FORM_ID:
	  FrmSetEventHandler(frm, mainFormEventHandler);
	  break;
	}
      handled = true;
    }

  return handled;
}
